% sensing_mtx.m
%   operator that represents the sensing matrix with
%   respect to the block scrambled Hadamard measurement matrix
%
% Input:
%   theta: sparse coefficients
%   H: the Hadamard matrix
%   WT: the transpose of sparsifying basis operator, e.g., idct or idwt
%   m: number of rows in the 2D-reshaped matrix of theta
%   n: number of columns in the 2D-reshaped matrix of theta
%   block_length: block length of the block scrambled Hadamard measurement
%   matrix
%   perm_x_ind: scramble index
%   msr_ind: measurements index
%   K: number of measurements
% Output:
%   y: the measurements
%
% Written: Hao Fang
% Created: Apr. 2013

function y= sensing_mtx(theta, H, WT, m, n, block_length, perm_x_ind, msr_ind, K)
    x = reshape(WT(reshape(theta, m, n)), m*n, 1);
    x_p = x(perm_x_ind);
    x_p_2D = reshape(x_p, block_length, m*n/block_length);
    y_2D = H * x_p_2D;
    y = y_2D(msr_ind(1:K));
    y = reshape(y, length(y(:)), 1);
end